IF OBJECT_ID('RC_CLASSE_INADIMPLENCIA') IS NULL
BEGIN
EXECUTE SP_EXECUTESQL N'
--DROP TABLE RC_CLASSE_INADIMPLENCIA
CREATE TABLE RC_CLASSE_INADIMPLENCIA (
	CD_CTR INT	IDENTITY(1,1) PRIMARY KEY,
	NM_CLASSE	VARCHAR(16) NOT NULL,
	DS_CLASSE	VARCHAR(64) NOT NULL,
	QT_DIA_INI	INT NOT NULL,
	QT_DIA_FIN	INT NOT NULL
)
CREATE UNIQUE INDEX UK_RC_CLASSE_INADIMPLENCIA_NOME ON RC_CLASSE_INADIMPLENCIA(NM_CLASSE)
'
END

IF OBJECT_ID('F_INADIMPLENCIA_PERIODO') IS NULL
BEGIN
EXECUTE SP_EXECUTESQL N'
--DROP FUNCTION F_INADIMPLENCIA_PERIODO
--SELECT * FROM F_INADIMPLENCIA_PERIODO(''2013-10-14'')
CREATE FUNCTION F_INADIMPLENCIA_PERIODO(@DT_BASE DATETIME)
RETURNS TABLE
AS
RETURN
SELECT	CD_CTR,NM_CLASSE,DS_CLASSE,@DT_BASE AS DT_BASE,DATEADD(DAY,-QT_DIA_FIN,@DT_BASE) AS DT_INI,DATEADD(DAY,-QT_DIA_INI,@DT_BASE) AS DT_FIN
FROM	RC_CLASSE_INADIMPLENCIA
'
END

IF OBJECT_ID('F_PERIODO') IS NULL
BEGIN
EXECUTE SP_EXECUTESQL N'
--DROP FUNCTION F_PERIODO
CREATE FUNCTION F_PERIODO(@DT_INI DATETIME,@DT_FIM DATETIME)
RETURNS @PERIODO TABLE (PARAM_DATA DATETIME)
AS
BEGIN
DECLARE @DT_AUX DATETIME = @DT_INI
WHILE DATEDIFF(DAY,@DT_AUX,@DT_FIM) >= 0
BEGIN
	INSERT INTO @PERIODO (PARAM_DATA) VALUES (@DT_AUX)
	SET @DT_AUX = DATEADD(DAY,1,@DT_AUX)
END
RETURN
END 
'
END